/*
This software module was originally developed by 
        Hang-Seop Lee (hslee@etri.re.kr), ETRI
        Jung-Chul Lee (jclee@etri.re.kr), ETRI
and edited by Hang-Seop Lee, Jung-Chul Lee of ETRI, 
in the course of development of the MPEG-4.
This software module is an implementation of a part of one or
more MPEG-4 tools as specified by the MPEG-4.
ISO/IEC gives users of the MPEG-4 free license to this                
software module or modifications thereof for use in hardware
or software products claiming conformance to the MPEG-4.
Those intending to use this software module in hardware or software
products are advised that its use may infringe existing patents.
The original developer of this software module and his/her company,
the subsequent editors and their companies, and ISO/IEC have no
liability for use of this software module or modifications thereof
in an implementation.
Copyright is not released for non MPEG-4 conforming
products. ETRI retains full right to use the code for his/her own
purpose, assign or donate the code to a third party and to
inhibit third parties from using the code for non
MPEG-4 conforming products.
This copyright notice must be included in all copies or
derivative works. Copyright (c) 1997.
*/    

/*****************************************
 Mnemonics 

32bit	TTS_Sequence_Start_Code ==> TTS_seq : 0x000000011
5bit	TTS_Sequence_ID		==> TTS_seq_id :  
10bit	Language_Code ==> L_code ----	
1bit	Gender_Enable ==> G_en      |	
1bit	Age_Enable ==> A_en         |	
1bit	Speech_Rate_Enable ==> R_en |	
1bit	Prosody_Enable ==> P_en     |
1bit	Video_Enable ==> V_en       |--- TTSinputType
1bit	Lip_Shape_Enable ==> L_en   |
1bit	Trick_Mode_Enable ==> T_en _|

32bit	TTS_Sentence_Start_Code ==> TTS_sent : 0x012121212
10	TTS_Sentence_ID ==> TTS_id : 	
1bit	Silence
12bit	    Silence_Duration ==> Sdur

1bit	    Gender	____________
3bit	    Age                     |___ TTSCmmd   
4bit	        Speech_Rate  _______|
12bit	    Length_of_Text ==> Ntext
?x8bit	    TTS_Text ==> Text

1bit		Dur_Enable ==> Dur_en		
1bit		F0_Contour_Enable ==> F0_en	
1bit		Energy_Contour_Enable ==> En_en	
10bit		Number_of_phonemes ==> Nphone
13bit		Phoneme_Symbols_Length ==> Lphone	
8bit		Phoneme_Symbols[] ==> Phone[]
12bit		Dur_each_Phoneme[] ==> Dur[]
3x8bit		F0_Contour_each_Phoneme[][] ==> Ptch[][]
3x8bit		Energy_Contour_each_Phoneme[][] ==> Energy[][]

16bit		Sentence_Duration ==> SntDur
16bit		Position_in_Sentence ==> PinSnt
10bit		Offset

10bit		Number_of_Lip ==> Nlip
16bit		Lip_in_Sentence[] ==> LinSnt[]
8bit		Lip_shape[] ==> Lshape[]
********************************************* */

int TTS_seq=0x000000011;
int TTS_sent=0x012121212;
char TTS_seq_id;
short L_code;
char G_en, A_en, R_en, P_en, V_en, L_en, T_en;
short TTS_id;
char Silence;
short Sdur;
char Gender, Age, Speech_Rate;
short Ntext;
char Text[500];
char Dur_en, F0_en, En_en;
short Nphone, Sphone;
char Phone[1000];
short Dur[1000];
char Ptch[1000][3], Energy[1000][3];
short SntDur, PinSnt, Offset, Nlip, LinSnt[1000];
char Lshape[1000];
char Niframe;

/* Bit assignment */
int BTTS_seq_id=5, BL_code=10, BG_en=1, BA_en=1, BR_en=1;
int BP_en=1, BV_en=1, BL_en=1, BT_en=1;
int BTTS_id=10;
int BSilence=1, BSdur=12;
int BGender=1, BAge=3, BSpeech_Rate=4;
int BNtext=12, BText=8;
int BDur_en=1, BF0_en=1, BEn_en=1;
int BNphone=10, BSphone=13, BPhone=8;
int BDur=12, BPtch=8, BEnergy=8;
int BSntDur=16, BPinSnt=16, BOffset=10;
int BNlip=10, BLinSnt=16, BLshape=8;
